/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.network;

import com.raoulvdberge.refinedstorage.api.network.grid.IGrid;
import com.raoulvdberge.refinedstorage.container.ContainerGrid;
import com.raoulvdberge.refinedstorage.network.MessageHandlerPlayerToServer;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MessageGridCraftingPreview
extends MessageHandlerPlayerToServer<MessageGridCraftingPreview>
implements IMessage {
    private UUID id;
    private int quantity;
    private boolean noPreview;
    private boolean fluids;

    public MessageGridCraftingPreview() {
    }

    public MessageGridCraftingPreview(UUID id, int quantity, boolean noPreview, boolean fluids) {
        this.id = id;
        this.quantity = quantity;
        this.noPreview = noPreview;
        this.fluids = fluids;
    }

    public void fromBytes(ByteBuf buf) {
        this.id = new UUID(buf.readLong(), buf.readLong());
        this.quantity = buf.readInt();
        this.noPreview = buf.readBoolean();
        this.fluids = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.id.getMostSignificantBits());
        buf.writeLong(this.id.getLeastSignificantBits());
        buf.writeInt(this.quantity);
        buf.writeBoolean(this.noPreview);
        buf.writeBoolean(this.fluids);
    }

    @Override
    public void handle(MessageGridCraftingPreview message, EntityPlayerMP player) {
        Container container = player.field_71070_bA;
        if (container instanceof ContainerGrid) {
            IGrid grid = ((ContainerGrid)container).getGrid();
            if (message.fluids) {
                if (grid.getFluidHandler() != null) {
                    grid.getFluidHandler().onCraftingPreviewRequested(player, message.id, message.quantity, message.noPreview);
                }
            } else if (grid.getItemHandler() != null) {
                grid.getItemHandler().onCraftingPreviewRequested(player, message.id, message.quantity, message.noPreview);
            }
        }
    }
}

